#!/usr/bin/perl
# トランザクション形式のデータと、トランザクション（最初のファイルの行）のクラスタを読み込み、各クラスタに含まれるアイテムのデータに変換するスクリプト


$ARGC = @ARGV;
if ( $ARGC < 2 ){
  printf ("cluster_relation.pl: cluster-file item-record-file [separator] > output-file\n");
  exit (1);
}
open (CH, "<$ARGV[0]");
open (UH, "<$ARGV[1]");
$sep = " "; $j=0;
if ( $ARGC >2 ){ $sep = $ARGV[2]; }  # separator

while (<CH>){  # クラスタ-record行列を転置して、各recordに対して、それを含むクラスタのリストを作る
  chomp;
  @eles = split($sep, $_);
  for $i ( @eles ){
    push (@{$record_cls[$i]}, $j);
  }
  $flag[$j] = 0;
  $j++;
}

$imax = 0;
while (<UH>){  # 各itemに対して、そのitemを含むレコードのリストを作る
  chomp;
  @eles = split($sep, $_);
  for $i ( @eles ){
    push (@{$item_record[$i]}, $j);
    if ( $imax < $i ){ $imax = $i; }
  }
}

for $i (0..$imax){  # 各item に対して、そのitemを含むクラスタに、itemIDを挿入
  for $ii ( @{$item_record[$i]} ){
    for $iii (@{$record_cls[$i]}){
      if ( $flag[$iii] == 0 ){  # 同一クラスタに同じユーザを2度入れないためのチェック
        push (@{$rel[$iii]}, $i);
        $flag[$iii] = 1;
      }
    }
  }
  for $ii ( @{$item_record[$i]} ){
    for $iii (@{$record_cls[$i]}){ $flag[$iii] = 0; }  # 重複チェック用フラグのクリア
  }
}

for $i (0..$j-1){ print "@{$rel[$i]}\n"; }  # 結果出力

close (CH,UH);

