#!/usr/bin/perl
# トランザクション形式のデータと、そのアイテムをクラスタリングした結果のファイルを受け取り、各トランザクションのアイテムを、それを含むクラスタで置き換える。アイテムが複数のクラスタに含まれる場合は、それらのクラスタ全部で置き換える


$ARGC = @ARGV;
if ( $ARGC < 3 ){
  printf ("cluster_relation.pl: cluster-file item-record-file table-file [separator] > output-file\n");
  exit (1);
}
open (CH, "<$ARGV[0]");
open (UH, "<$ARGV[1]");
open (TH, "<$ARGV[2]");
$sep = " ";
if ( $ARGC >3 ){ $sep = $ARGV[3]; }  # separator

$item_max = 0; $table_max = 0;
while (<UH>){  # クラスタ-record行列を転置して、各recordに対して、それを含むクラスタのリストを作る
  chomp; @e = split($sep, $_);
  for $i (@e){ if ( $item_max < $i ){ $item_max = $i; } }
}

while (<TH>){  # 変換テーブルファイルの読み込み
  chomp; @e = split($sep, $_);
  $table[$e[0]] = $e[1];
  if ( $table_max < $e[0] ){ $table_max = $e[0]; }
}
close TH; open (TH, ">>$ARGV[2]");

$j=1; @item_cls = ();
while (<CH>){  # クラスタ-record行列を転置して、各recordを含むクラスタのリストを作る
  chomp; @e = split($sep, $_);
  $jj = $j + $table_max;
##
#  for $i (@e){ push (@{$item_cls[$i]}, $jj); }
#  print TH "$jj $table[$e[0]]\n";
  print TH "$jj ("; $sep_ = "";
  for $i (@e){ push (@{$item_cls[$i]}, $jj); print TH "$sep_$table[$i]"; $sep_ = ","; }
  print TH ")\n";
##
  $j++;
}

close UH, CH, TH;
open (UH, "<$ARGV[1]");

$imax = 0;
while (<UH>){  # 各itemを変換して出力
  chomp; @e = split($sep, $_);
  $sep_ = "";
  for $i (@e){
    $a = @{$item_cls[$i]};
    if ( $a > 0 ){ for $j (@{$item_cls[$i]}){ print "$sep_$j"; $sep_ = " "; }}
    else { print "$sep_$i"; }
    $sep_ = " ";
  }
  print "\n";
}

close UH;

