/* SACHICA: Scalable Algorithm for Characteristic and Homologinous Interval CAlclation */
/* 2004 Takeaki Uno */
/* matdraw */

#ifndef _grhfil_c_
#define _grhfil_c_

// #define FSTAR_INT unsigned int

#define WEIGHT_DOUBLE

#include"fstar.c"
#include"problem.c"

#define GRHFIL_INS_ROWID 1024

/* error routine */
void GRHFIL_error (){
  ERROR_MES = "command explanation";
  print_err ("graph filtering: transform/convert/extract graph/subgraph\n\
grhfil dDUBeEq [options] input-file output-file\n\
%%:show progress, _:no message, +:write solutions in append mode\n\
d:directed graph (x->y), D:directed graph with reverse direction (x<-y)\n\
U,u:undirected graph (u:edge for both direction), B:bipartite graph, e,E:read/write file as edge list\n\
s,S:sort vertex adjacent list in increasing/decreasing order\n\
n,N:read/write the number of vertices and edges written in/at 1st line of the file\n\
v,V:node ID in read/write file starts from 1, q:non-transform mode (valid with -P option)\n\
0:insert vertex ID as the first entry, for each vertex (adjacency list mode)\n\
w,W:read/write edge weights in the graph file\n\
1:unify consecutive two same numbers into one\n\
[options]\n\
-t,T [num]: remove vertices with degree smaller/larger then [num]\n\
-i,I [num]: remove vertices with in-degree smaller/larger then [num]\n\
-o,O [num]: remove vertices with out-degree smaller/larger then [num]\n\
-r,R [num]: remove edges with weights smaller/larger then [num]\n\
-w,W [filename]: weight file to be read/write\n\
-m [filename]: take intersection with graph of [filename]\n\
-M [filename]: take union with graph of [filename]\n\
-p [filename]: permute the vertex ID to coutinuous numbering and output the permutation table to the file\n\
-Q [filename]: permute the numbers in the file according to the table \n");
  EXIT;
}

/* read filenames from command line parameters */
void GRHFIL_read_param (PROBLEM *PP, int argc, char *argv[]){
  int c=1;
  FSTAR *FS = &PP->FS;
  if ( argc<c+3 ){ GRHFIL_error (); return; }
  FS->edge_dir = 2;
  
  if ( !strchr (argv[c], '_') ){ FS->flag |= SHOW_MESSAGE; }
  if ( strchr (argv[c], '+') ) PP->II.flag |= ITEMSET_APPEND;
  if ( strchr(argv[c], 'U') ) FS->edge_dir = 0;
  if ( strchr(argv[c], 'u') ){ FS->flag |= LOAD_EDGE; PP->problem |= LOAD_EDGE; FS->edge_dir = 0; }
  if ( strchr(argv[c], 'B') ){ FS->flag |= LOAD_BIPARTITE; FS->edge_dir = 1; }
  if ( strchr(argv[c], 'D') ){ FS->edge_dir = -1; FS->flag |= LOAD_TPOSE; }
  if ( strchr(argv[c], 'd') ) FS->edge_dir = 1;
  if ( strchr(argv[c], 'e') ) FS->flag |= LOAD_ELE;
  if ( strchr(argv[c], 'E') ) PP->problem |= LOAD_ELE;
  if ( strchr(argv[c], 's') ) FS->flag |= LOAD_INCSORT;
  if ( strchr(argv[c], 'S') ) FS->flag |= LOAD_DECSORT;
  if ( strchr(argv[c], 'n') ) FS->flag |= LOAD_GRAPHNUM;
  if ( strchr(argv[c], 'N') ) PP->problem |= LOAD_GRAPHNUM;
  if ( strchr(argv[c], 'w') ) FS->flag |= LOAD_EDGEW;
  if ( strchr(argv[c], 'W') ) PP->problem |= LOAD_EDGEW;
  if ( strchr(argv[c], 'v') ) FS->flag |= LOAD_ID1;
  if ( strchr(argv[c], 'V') ) PP->problem |= LOAD_ID1;
  if ( strchr(argv[c], 'q') ){ PP->root = 1; FS->edge_dir = 0; }
  if ( strchr(argv[c], '0') ){ PP->problem |= FSTAR_INS_ROWID; }
  if ( strchr(argv[c], '1') ){ PP->problem |= LOAD_RM_DUP; }
  if ( FS->edge_dir == 2 ) error ("one of D, d, u or U has to be given", EXIT);

  c++;
  while ( argv[c][0] == '-' ){
    switch (argv[c][1]){
      case 't': FS->deg_lb = atoi(argv[c+1]);
      break; case 'T': FS->deg_ub = atoi(argv[c+1]);
      break; case 'i': FS->in_lb = atoi(argv[c+1]);
      break; case 'I': FS->in_ub = atoi(argv[c+1]);
      break; case 'o': FS->out_lb = atoi(argv[c+1]);
      break; case 'O': FS->out_ub = atoi(argv[c+1]);
      break; case 'r': FS->w_lb = atof(argv[c+1]);
      break; case 'R': FS->w_ub = atof(argv[c+1]);
      break; case 'w': FS->wfname = argv[c+1];
      break; case 'W': PP->weight_fname = argv[c+1];
      break; case 'p': PP->table_fname = argv[c+1];
      break; case 'Q': PP->table_fname = argv[c+1]; PP->dir =1;
      break; case 'm': PP->input_fname = argv[c+1]; PP->edge_dir=1;
      break; case 'M': PP->input_fname = argv[c+1]; 
      break; case ',': PP->II.separator = argv[c+1][0];
      break; default: goto NEXT;
    }
    c += 2;
    if ( argc<c+2 ){ GRHFIL_error (); return; }
  }
  
  NEXT:;
  PP->FS.fname = argv[c];
  PP->output_fname = argv[c+1];
  print_mes (FS, "input-file %s, output-file %s\n", PP->FS.fname, PP->output_fname);
  print_mes (FS, "degree threshold: ");
  if ( FS->deg_lb>0 ) print_mes (FS, FSTAR_INTF" <", FS->deg_lb);
  if ( FS->deg_lb>0 || FS->deg_ub<FSTAR_INTHUGE) print_mes (FS, " degree ");
  if ( FS->deg_ub<FSTAR_INTHUGE ) print_mes (FS, "< "FSTAR_INTF"  ", FS->deg_ub);

  if ( FS->in_lb>0 ) print_mes (FS, FSTAR_INTF" <", FS->in_lb);
  if ( FS->in_lb>0 || FS->in_ub<FSTAR_INTHUGE) print_mes (FS, " in-degree ");
  if ( FS->in_ub<FSTAR_INTHUGE ) print_mes (FS, "< "FSTAR_INTF"  ", FS->in_ub);
  
  if ( FS->out_lb>0 ) print_mes (FS, FSTAR_INTF" <", FS->out_lb);
  if ( FS->out_lb>0 || FS->out_ub<FSTAR_INTHUGE) print_mes (FS, " out-degree ");
  if ( FS->out_ub<FSTAR_INTHUGE ) print_mes (FS, "< "FSTAR_INTF"  ", FS->out_ub);
  print_mes (FS, "\n");
  
  if ( PP->table_fname ) print_mes (FS, "permutation-table-file %s\n", PP->table_fname);

}

/* take union/intersection of the current graph with the file */
void GRHFIL_union (PROBLEM *PP){
  FILE2 fp;
  FILE *out_fp;
  FSTAR_INT i, x, item, mode = 0;
  
  FILE2_open (fp, PP->input_fname, "r", EXIT);
  fopen2 (out_fp, PP->output_fname, "w", EXIT);
  FSTAR_sort_adjacent_node (&PP->FS, 1);

  i=0; while (1){
//  FLOOP (i, 0, PP->FS.out_node_num){

    if ( i >= PP->FS.out_node_num ){  // graph in memory ends
      if ( PP->edge_dir == 0 && mode == 0 ) mode = 1; // but graph in file remains
      else break;
    }
    x = PP->FS.fstar[i];
    do {
      item = (mode & 2)? PP->FS.node_num+1: FILE2_read_int (&fp);
      if ( (FILE_err&4)==0 ){
        if ( (mode & 1) == 0 ){
          while ( x < PP->FS.fstar[i+1] && PP->FS.edge[x] < item ){
            if ( PP->edge_dir == 0 ) fprintf (out_fp, "%d%c", PP->FS.edge[x], PP->II.separator);
            x++;
          }
          if ( (mode & 2)==0 ){
            if ( x < PP->FS.fstar[i+1] ){
              if ( item == PP->FS.edge[x] ){ x++; fprintf (out_fp, "%d%c", item, PP->II.separator);}
              else if ( PP->edge_dir == 0 ) fprintf (out_fp, "%d%c", item, PP->II.separator);
            } else if ( PP->edge_dir == 0 ) fprintf (out_fp, "%d%c", item, PP->II.separator);
          }
        } else if ( PP->edge_dir == 0 ) fprintf (out_fp, "%d%c", item, PP->II.separator);
      }
    } while ( (FILE_err&3)==0);
    if ( (mode & 1) == 0 ){
      while ( x < PP->FS.fstar[i+1] ){
        if ( PP->edge_dir == 0 ) fprintf (out_fp, "%d%c", PP->FS.edge[x], PP->II.separator);
        x++;
      }
    }
    fprintf (out_fp, "\n");
    if ( FILE_err & 2 ){  // graph in file ends
      FILE_err = 0;
      if ( PP->edge_dir == 0 && mode==0 ) mode = 2; // but graph in memory remains
      else break;
    }
    i++;
  }
  FILE2_close (&fp);
  fclose2 (out_fp);
}


/* main routine */
int GRHFIL_main (int argc, char *argv[]){
  PROBLEM PP;
  FSTAR *FS = &PP.FS;
  FILE2 fp, fp2;
  LONG l, x;
  char i;
  WEIGHT w;

  PROBLEM_init (&PP);
  GRHFIL_read_param (&PP, argc, argv);
  if ( PP.dir ) ARY_LOAD (PP.FS.table, int, l, PP.table_fname, 1, EXIT);

    // no transformation (just replace the numbers and separators)
  if ( PP.root ){
    FILE2_open (fp, FS->fname, "r", EXIT);
    FILE2_open (fp2, PP.output_fname, "w", EXIT);
    do {
      i=0; x=0;
      do {
        l = FILE2_read_int (&fp);
        if ( (FILE_err&4)==0 ){
          FILE2_print_int (&fp2, FS->table? FS->table[l]: l, i);
          i = PP.II.separator;
          if ( (FS->flag&LOAD_EDGEW) && (((FS->flag&LOAD_ELE)&&x==1) || !(FS->flag&LOAD_ELE)) ){
            w = FILE2_read_double (&fp);
            FILE2_print_int (&fp2, w, i);
          }
          FILE2_flush (&fp2);
        }
        x++;
      } while ( (FILE_err&3)==0 );
      FILE2_puts (&fp2, "\n");
    } while ( (FILE_err&2)==0 );
    FILE2_close (&fp);
    FILE2_closew (&fp2);
    return (0);
  }
  
  PROBLEM_load (&PP);

  FS->flag = PP.problem; // +(FS->flag&LOAD_EDGE);
  if ( !PP.dir ) FSTAR_write_table_file (FS, PP.table_fname);

  if ( PP.input_fname ) GRHFIL_union (&PP);
  else if ( FS->flag & LOAD_ELE ) FSTAR_write_graph_edge (FS, PP.output_fname);
  else FSTAR_write_graph_node (FS, PP.output_fname, PP.weight_fname);

  PROBLEM_end (&PP);
  return (0);
}

/*******************************************************************************/
#ifndef _NO_MAIN_
#define _NO_MAIN_
int main (int argc, char *argv[]){
  return (GRHFIL_main (argc, argv));
}
#endif
/*******************************************************************************/

#endif



