#!/usr/bin/perl
# データ（各行がレコード）と、クラスタファイル（各行がクラスタで、０から始まる行番号の集合）を受け取り、各クラスタのメンバーを表示する
# [IDseparator] が指定されているとき、datafile の各行の最初の IDseparator までがIDだと思って
# 変換テーブルを作る


$ARGC = @ARGV;
if ( $ARGC < 2 ){
  printf ("print_cluster.pl: cluster-file data-file [cluster-file separator] [output-file separator2] [data-file separator] > output-file\n");
  exit (1);
}
open (CH, "<$ARGV[0]");
open (DH, "<$ARGV[1]");
$sep = " "; $sep2 = " "; $j=0; $IDsep = "";
if ( $ARGC >2 ){ $sep = $ARGV[2]; }  # separator for cluster file
if ( $ARGC >3 ){ $sep2 = $ARGV[3]; }  # separator for output file
if ( $ARGC >4 ){ $IDsep = $ARGV[4]; }  # separator for data-file
if ( $sep2 eq "\\n" ){ $sep2 = "\n"; }
while (<DH>){
  chomp;
  $e0 = $j; $e1 = $_; 
  if ( $IDsep ne "" ){
    $e0 = $_; 
    $e0 =~ s/$IDsep.*$//;
    $e1 =~ s/^[^$IDsep]*$IDsep//;
  }
  $data{$e0} = $e1;
  $j++;
}


while (<CH>){  # クラスタ-record行列を転置して、各recordに対して、それを含むクラスタのリストを作る
  chomp;
  @eles = split($sep, $_);

  for $i ( @eles ){
    if ( exists $data{$i} ){ print "$data{$i}$sep2"; }
  }
  print "\n\n";
}

close (CH,DH);

