#!/usr/bin/perl

# transform the numbers to the strings according to the table file
# each line of the table file shows correspondence; num,"string"
# basically, this script is for untransform the numbers transformed by 
# the transnum.pl

# if separator for output file is "\n\n", output csv style file with cluster ID

use Text::ParseWords;

$ARGC = @ARGV;
if ( $ARGC < 1 ){
      # error routine
  printf ("untransnum.pl: table-file [separator] [separator2] < input-file > output-file\n");
  exit (1);
}
    # initialization
open (TABLEFILE, "<$ARGV[0]" );
%numbers = ();
$c=0;
$sep=" "; $sep2=" "; $sep3=" "; $IDflag = 0;
if ( $ARGC >1 ){ $sep = $ARGV[1]; if ( $sep eq "\\n" ){ $sep = "\n";}}  # separator for input
if ( $ARGC >2 ){ $sep2 = $ARGV[2];
 if ( $sep2 eq "\\n" ){ $sep2 = "\n";} #separator for output
 if ( $sep2 eq "\\n\\n" ){ $sep2 = "\n"; $IDflag = 1; } #separator for output
}
if ( $ARGC >3 ){ $sep3 = $ARGV[3];  if ( $sep3 eq "\\n" ){ $sep3 = "\n";}}  # separator for table

    # read transform-table
while (<TABLEFILE>){
  chomp;
  $e0 = $_; $e1 = $_;
  $e0 =~ s/$sep3.*$//;
  $e1 =~ s/^[^$sep3^]*$sep3//;
  $numbers{$e0} = $e1;
  $c++;
}

    # read transform-file
$ID = 1;
while (<STDIN>){
  $_ =~ s/[\r\n]//g;
  chomp;
  $_ =~ s/$sep$sep/$sep/g;
  @eles = split($sep, $_);
  $all = @eles;
  $c = 0;
  for $item( @eles ){
    if ( $IDflag == 1 ){ print "$ID,"; }
    if ( $item < 0 ){
        print "*";
    } elsif (!exists $numbers{$item}){ 
      print "$item";
    } else { print "$numbers{$item}"; }
    $c++;
    if ($c<$all){ print $sep2;}
  }
  print "\n";
  if ( $sep2 eq "\n" && $IDflag == 0 ){ print "\n"; }
  $ID++;
  
}
